<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || ($_SERVER['SERVER_PORT'] ?? null) == 443;
    session_set_cookie_params(['lifetime'=>0,'path'=>'/','domain'=>$_SERVER['HTTP_HOST'] ?? '','secure'=>$https,'httponly'=>true,'samesite'=>'Lax']);
    session_start();
}
require_once __DIR__ . '/../app/helpers/functions.php';
$route = $_GET['route'] ?? 'dashboard/index';
list($ctrl,$action) = array_pad(explode('/',$route,2),2,'index');
$controllerName = ucfirst($ctrl) . 'Controller';
$action = $action ?: 'index';
$file = __DIR__ . '/../app/controllers/' . $controllerName . '.php';
if (!is_file($file)) { http_response_code(404); echo "Controller não encontrado: " . e($controllerName); exit; }
require_once $file;
$controller = new $controllerName();
if (!method_exists($controller,$action)) { if (method_exists($controller,'index')) { $controller->index(); exit; } http_response_code(404); echo "Ação não encontrada: " . e($controllerName.'::'.$action); exit; }
$controller->$action();
