-- Schema completo
CREATE TABLE IF NOT EXISTS geral (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  escola_nome VARCHAR(120) DEFAULT NULL,
  escola_logo VARCHAR(255) DEFAULT NULL,
  admin_password_hash VARCHAR(255) DEFAULT NULL,
  idle_timeout_minutes INT DEFAULT 240
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS professores (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  matricula VARCHAR(50),
  nome VARCHAR(120),
  disciplina VARCHAR(120),
  carga_semana TIME DEFAULT NULL,
  tipo ENUM('Concursado','Contratado') DEFAULT NULL,
  regime ENUM('Designado','Exercício') DEFAULT NULL,
  turnos VARCHAR(50) DEFAULT NULL,
  observacoes TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS feriados (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  data DATE NOT NULL UNIQUE,
  descricao VARCHAR(120) NOT NULL,
  is_nacional TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY idx_data (data)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO geral (escola_nome, escola_logo, admin_password_hash, idle_timeout_minutes)
VALUES ('Minha Escola', 'uploads/logo.png', NULL, 240)
ON DUPLICATE KEY UPDATE escola_nome=VALUES(escola_nome);
