<?php
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/navbar.php';
?>
<h2 class="h4 mb-3 no-print">Folha de Ponto — <?php echo e(($mesNome ?? '') . ' / ' . ($ano ?? '')); ?></h2>
<div class="table-responsive">
  <table class="table table-bordered align-middle table-sm">
    <thead class="table-light"><tr><th style="width:70px;">Data</th><th>Dia da Semana</th><th>Manhã (entrada/saída/rúbrica)</th><th>Tarde (entrada/saída/rúbrica)</th><th>Noite (entrada/saída/rúbrica)</th></tr></thead>
    <tbody>
      <?php foreach ($dias as $d): $isF = isset($ferMap[$d['data']]); $descF = $isF ? $ferMap[$d['data']] : ''; ?>
      <tr class="<?php echo $isF ? 'table-warning' : ''; ?>">
        <td><?php echo e($d['data']); ?></td>
        <td><?php echo e($d['dow']); ?><?php if ($isF): ?> <span class="badge bg-danger ms-2">FERIADO</span> <small class="text-muted ms-1"><?php echo e($descF); ?></small><?php endif; ?></td>
        <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<style>@media print { @page { size: A4 portrait; margin: 12mm; } .navbar, .no-print { display:none !important; } .card, .card * { visibility: visible !important; } .card { page-break-inside: avoid; } }</style>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
