<?php
$current = isset($_GET['route']) && is_string($_GET['route']) ? $_GET['route'] : '';
function is_active(string $needle, ?string $haystack = null): string {
    $h = $haystack ?? ($GLOBALS['current'] ?? '');
    if ($needle === '' || !is_string($h)) return '';
    return (strpos((string)$h, $needle) === 0) ? 'active' : '';
}
require_once __DIR__ . '/../../models/Geral.php';
require_once __DIR__ . '/../../helpers/functions.php';
$geral = $geral ?? Geral::get();
$escolaNome = isset($geral['escola_nome']) ? $geral['escola_nome'] : '';
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand d-flex align-items-center" href="index.php?route=dashboard/index">
      <span>Folha Ponto</span>
      <?php if ($escolaNome !== ''): ?>
        <span class="navbar-text ms-2 small text-light">– <?php echo e($escolaNome); ?></span>
      <?php endif; ?>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar" aria-controls="mainNavbar" aria-expanded="false" aria-label="Alternar navegação">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="mainNavbar">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link <?php echo is_active('dashboard/'); ?>" href="index.php?route=dashboard/index">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link <?php echo is_active('professores/'); ?>" href="index.php?route=professores/index">Professores</a></li>
        <li class="nav-item"><a class="nav-link <?php echo is_active('relatorios/'); ?>" href="index.php?route=relatorios/professores">Relatórios</a></li>
        <li class="nav-item"><a class="nav-link <?php echo is_active('feriados/'); ?>" href="index.php?route=feriados/index">Feriados</a></li>
        <li class="nav-item"><a class="nav-link <?php echo is_active('administracao/'); ?>" href="index.php?route=administracao/index">Administração</a></li>
      </ul>
      <div class="d-flex ms-3">
        <a class="btn btn-outline-light btn-sm" href="index.php?route=auth/logout">Sair</a>
      </div>
    </div>
  </div>
</nav>
<div class="container my-4">
