<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema de Folha Ponto</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; min-height: 100vh; display: flex; align-items: center; justify-content: center; flex-direction: column; padding: 20px; }
        .school-logo { max-height: 80px; margin-bottom: 10px; }
        .school-name { font-size: 1.3rem; font-weight: bold; margin-bottom: 25px; text-align: center; color: #333; }
        .login-card { max-width: 380px; width: 100%; }
    </style>
</head>
<body>
<?php
require_once __DIR__ . '/../models/Geral.php';
require_once __DIR__ . '/../helpers/functions.php';
$geral = Geral::get();
$logoRel = $geral['escola_logo'] ?? '';
$schoolName = $geral['escola_nome'] ?? '';
$logoSrc = $logoRel ? e(base_url(ltrim($logoRel, '/'))) : '';
?>
    <?php if ($logoSrc): ?><img src="<?php echo $logoSrc; ?>" alt="Logo da Escola" class="school-logo"><?php endif; ?>
    <?php if ($schoolName): ?><div class="school-name"><?php echo e($schoolName); ?></div><?php endif; ?>
    <div class="card shadow login-card">
        <div class="card-header text-center"><h4>Sistema de Folha Ponto</h4></div>
        <div class="card-body">
            <?php if (!empty($error)): ?><div class="alert alert-danger"><?php echo e($error); ?></div><?php endif; ?>
            <form method="POST" action="">
                <div class="mb-3"><label for="username" class="form-label"><strong>Usuário</strong></label><input type="text" class="form-control" id="username" name="username" required></div>
                <div class="mb-3"><label for="password" class="form-label"><strong>Senha</strong></label><input type="password" class="form-control" id="password" name="password" required></div>
                <button type="submit" class="btn btn-primary w-100">Entrar</button>
            </form>
        </div>
    </div>
</body>
</html>
