<?php
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/navbar.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3"><h2 class="h4 mb-0">Feriados</h2></div>
<form class="row g-2 align-items-end mb-3" method="get">
  <input type="hidden" name="route" value="feriados/index">
  <div class="col-auto"><label class="form-label">Ano</label><input type="number" min="2000" max="2100" class="form-control" name="ano" value="<?php echo (int)($ano ?? date('Y')); ?>"></div>
  <div class="col-auto"><button class="btn btn-primary">Filtrar</button> <a class="btn btn-outline-secondary" href="index.php?route=feriados/index">Limpar</a></div>
  <div class="col-auto ms-auto"><button type="button" class="btn btn-success" onclick="document.getElementById('importNacionais').submit()">Atualizar feriados nacionais</button></div>
</form>
<form id="importNacionais" class="d-none" action="index.php?route=feriados/atualizar" method="post"><input type="hidden" name="ano" value="<?php echo (int)($ano ?? date('Y')); ?>"></form>
<div class="card mb-3"><div class="card-body">
  <form class="row g-2 align-items-end" method="post" action="index.php?route=feriados/create">
    <div class="col-12 col-md-3"><label class="form-label">Data</label><input type="date" name="data" class="form-control" required></div>
    <div class="col-12 col-md-6"><label class="form-label">Descrição</label><input type="text" name="descricao" class="form-control" maxlength="120" required></div>
    <div class="col-12 col-md-3 text-end"><button class="btn btn-primary">Adicionar</button></div>
  </form>
</div></div>
<div class="table-responsive">
  <table class="table table-hover align-middle">
    <thead class="table-light"><tr><th>Data</th><th>Dia</th><th>Descrição</th><th class="text-center">Nacional?</th><th class="text-end">Ações</th></tr></thead>
    <tbody>
      <?php if (empty($list)): ?><tr><td colspan="5" class="text-muted">Nenhum feriado encontrado.</td></tr>
      <?php else: foreach ($list as $f): $dt=DateTime::createFromFormat('Y-m-d',$f['data']); $dow=['Dom','Seg','Ter','Qua','Qui','Sex','Sáb'][(int)$dt->format('w')]; ?>
        <tr>
          <td><?php echo $dt->format('d/m/Y'); ?></td><td><?php echo $dow; ?></td><td><?php echo e($f['descricao']); ?></td>
          <td class="text-center"><?php echo ((int)$f['is_nacional']===1)?'<span class="badge bg-success">Sim</span>':'<span class="badge bg-secondary">Não</span>'; ?></td>
          <td class="text-end"><a class="btn btn-sm btn-outline-danger" href="index.php?route=feriados/delete&id=<?php echo (int)$f['id']; ?>&ano=<?php echo (int)($ano ?? date('Y')); ?>" onclick="return confirm('Remover este feriado?')">Excluir</a></td>
        </tr>
      <?php endforeach; endif; ?>
    </tbody>
  </table>
</div>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
