<?php
require_once __DIR__ . '/../core/DB.php';
class Professor {
    public static function all(array $filters = []): array {
        try {
            $order = in_array(($filters['order_by'] ?? 'nome'), ['nome','matricula'], true) ? $filters['order_by'] : 'nome';
            $sql = "SELECT * FROM professores"; $where=[]; $params=[];
            if (!empty($filters['tipo'])) { $where[]="tipo = ?"; $params[]=$filters['tipo']; }
            if (!empty($filters['regime'])) { $where[]="regime = ?"; $params[]=$filters['regime']; }
            if (!empty($filters['turno'])) { $where[]="turnos LIKE ?"; $params[]='%'.$filters['turno'].'%'; }
            if ($where) $sql .= " WHERE " . implode(" AND ", $where);
            $sql .= " ORDER BY $order ASC";
            $st=DB::pdo()->prepare($sql); $st->execute($params); return $st->fetchAll();
        } catch (Throwable $e) { return []; }
    }
    public static function getById(int $id): ?array {
        try { $st=DB::pdo()->prepare("SELECT * FROM professores WHERE id=?"); $st->execute([$id]); $r=$st->fetch(); return $r?:null; } catch (Throwable $e) { return null; }
    }
}
