<?php
require_once __DIR__ . '/../core/DB.php';
class Feriado {
    public static function all(array $filters=[]): array {
        $sql="SELECT * FROM feriados"; $where=[]; $params=[];
        if (!empty($filters['ano'])) { $where[]="YEAR(data)=?"; $params[]=(int)$filters['ano']; }
        if ($where) $sql .= " WHERE " . implode(" AND ", $where);
        $sql .= " ORDER BY data ASC";
        try { $st=DB::pdo()->prepare($sql); $st->execute($params); return $st->fetchAll(PDO::FETCH_ASSOC); } catch (Throwable $e){ return []; }
    }
    public static function byMonthYear(int $mes,int $ano): array { try { $st=DB::pdo()->prepare("SELECT * FROM feriados WHERE YEAR(data)=? AND MONTH(data)=? ORDER BY data ASC"); $st->execute([$ano,$mes]); return $st->fetchAll(PDO::FETCH_ASSOC);} catch (Throwable $e){return [];} }
    public static function findByDate(string $d): ?array { $st=DB::pdo()->prepare("SELECT * FROM feriados WHERE data=?"); $st->execute([$d]); $r=$st->fetch(PDO::FETCH_ASSOC); return $r?:null; }
    public static function upsert(string $d,string $desc,int $isN=1): bool {
        $ex=self::findByDate($d);
        if($ex){ $st=DB::pdo()->prepare("UPDATE feriados SET descricao=?, is_nacional=? WHERE data=?"); return $st->execute([$desc,$isN,$d]); }
        else { $st=DB::pdo()->prepare("INSERT INTO feriados (data,descricao,is_nacional) VALUES (?,?,?)"); return $st->execute([$d,$desc,$isN]); }
    }
    public static function delete(int $id): bool { $st=DB::pdo()->prepare("DELETE FROM feriados WHERE id=?"); return $st->execute([$id]); }
    public static function atualizarNacionais(int $ano): int { $map=self::nacionaisBrasil($ano); $n=0; foreach($map as $ymd=>$desc){ if(self::upsert($ymd,$desc,1)) $n++; } return $n; }
    public static function nacionaisBrasil(int $ano): array {
        $fixos=["$ano-01-01"=>"Confraternização Universal","$ano-04-21"=>"Tiradentes","$ano-05-01"=>"Dia do Trabalho","$ano-09-07"=>"Independência do Brasil","$ano-10-12"=>"Nossa Senhora Aparecida","$ano-11-02"=>"Finados","$ano-11-15"=>"Proclamação da República","$ano-12-25"=>"Natal"];
        $e=self::calcularPascoa($ano); $mov=[]; $c=(clone $e)->modify('-47 days'); $mov[$c->format('Y-m-d')]='Carnaval (Terça-feira)'; $s=(clone $e)->modify('-2 days'); $mov[$s->format('Y-m-d')]='Sexta-Feira Santa'; $mov[$e->format('Y-m-d')]='Domingo de Páscoa'; $cc=(clone $e)->modify('+60 days'); $mov[$cc->format('Y-m-d')]='Corpus Christi'; return $fixos+$mov;
    }
    private static function calcularPascoa(int $ano): DateTime { $a=$ano%19;$b=intdiv($ano,100);$c=$ano%100;$d=intdiv($b,4);$e=$b%4;$f=intdiv($b+8,25);$g=intdiv($b-$f+1,3);$h=(19*$a+$b-$d-$g+15)%30;$i=intdiv($c,4);$k=$c%4;$l=(32+2*$e+2*$i-$h-$k)%7;$m=intdiv($a+11*$h+22*$l,451);$month=intdiv($h+$l-7*$m+114,31);$day=(($h+$l-7*$m+114)%31)+1; return DateTime::createFromFormat('Y-n-j',"$ano-$month-$day"); }
}
