<?php
function e($s) { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function base_url(string $path = ''): string {
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $base = $scheme . '://' . $host;
    $script = $_SERVER['SCRIPT_NAME'] ?? '/public/index.php';
    $dir = rtrim(str_replace('\\','/', dirname($script)), '/');
    if ($dir !== '' && $dir != '/') $base += $dir;
    if (!str_ends_with($base, '/public')) $base .= '/public';
    $path = ltrim($path, '/');
    return $base . ($path ? '/' . $path : '');
}
function redirect(string $route) {
    $url = 'index.php?route=' . urlencode($route);
    header("Location: $url");
    exit;
}
