<?php
require_once __DIR__ . '/../core/Auth.php';
require_once __DIR__ . '/../helpers/functions.php';
require_once __DIR__ . '/../models/Geral.php';
require_once __DIR__ . '/../models/Feriado.php';
require_once __DIR__ . '/../models/Professor.php';
class RelatoriosController {
    public function index(){ redirect('relatorios/professores'); }
    public function folha(){
        Auth::startSession(); $geral=Geral::get(); Auth::enforceIdleTimeout($geral['idle_timeout_minutes'] ?? 240); Auth::requireLogin();
        $today=new DateTime('now'); $next=(clone $today)->modify('first day of next month');
        $mes=(int)($_GET['mes'] ?? (int)$next->format('n')); $ano=(int)($_GET['ano'] ?? (int)$today->format('Y'));
        $start=DateTime::createFromFormat('Y-n-j',"$ano-$mes-1"); $end=(clone $start)->modify('last day of this month'); $dias=[];
        for($d=(clone $start); $d<=$end; $d->modify('+1 day')){ $dias[]=['data'=>$d->format('d/m'),'dow'=>['Domingo','Segunda','Terça','Quarta','Quinta','Sexta','Sábado'][(int)$d->format('w')]]; }
        $meses=[1=>'Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro']; $mesNome=$meses[$mes] ?? 'Mês';
        $feriadosMes=Feriado::byMonthYear($mes,$ano); $ferMap=[]; foreach($feriadosMes as $f){ $dt=DateTime::createFromFormat('Y-m-d',$f['data']); if($dt) $ferMap[$dt->format('d/m')]=$f['descricao']; }
        $view=[dirname(__DIR__).'/views/relatorios/folha.php', dirname(__DIR__).'/views/relatorios/folha_ponto.php']; $vf=null; foreach($view as $v){ if(is_file($v)){ $vf=$v; break; } } if(!$vf){ http_response_code(500); echo 'View da Folha não encontrada.'; exit; }
        include $vf;
    }
    public function professores(){
        Auth::startSession(); $geral=Geral::get(); Auth::enforceIdleTimeout($geral['idle_timeout_minutes'] ?? 240); Auth::requireLogin();
        include dirname(__DIR__) . '/views/relatorios/professores.php';
    }
}
